// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/web_socket.mojom
//

package org.chromium.mojom.mojo;

class WebSocketClient_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<WebSocketClient, WebSocketClient.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<WebSocketClient, WebSocketClient.Proxy>() {
    
        public String getName() {
            return "mojo::WebSocketClient";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, WebSocketClient impl) {
            return new Stub(core, impl);
        }
    
        public WebSocketClient[] buildArray(int size) {
          return new WebSocketClient[size];
        }
    };

    private static final int DID_CONNECT_ORDINAL = 0;
    private static final int DID_RECEIVE_DATA_ORDINAL = 1;
    private static final int DID_RECEIVE_FLOW_CONTROL_ORDINAL = 2;
    private static final int DID_FAIL_ORDINAL = 3;
    private static final int DID_CLOSE_ORDINAL = 4;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements WebSocketClient.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void didConnect(String selectedSubprotocol, String extensions, org.chromium.mojo.system.DataPipe.ConsumerHandle receiveStream) {
            WebSocketClientDidConnectParams _message = new WebSocketClientDidConnectParams();
            _message.selectedSubprotocol = selectedSubprotocol;
            _message.extensions = extensions;
            _message.receiveStream = receiveStream;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(DID_CONNECT_ORDINAL)));
        }

        @Override
        public void didReceiveData(boolean fin, int type, int numBytes) {
            WebSocketClientDidReceiveDataParams _message = new WebSocketClientDidReceiveDataParams();
            _message.fin = fin;
            _message.type = type;
            _message.numBytes = numBytes;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(DID_RECEIVE_DATA_ORDINAL)));
        }

        @Override
        public void didReceiveFlowControl(long quota) {
            WebSocketClientDidReceiveFlowControlParams _message = new WebSocketClientDidReceiveFlowControlParams();
            _message.quota = quota;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(DID_RECEIVE_FLOW_CONTROL_ORDINAL)));
        }

        @Override
        public void didFail(String message) {
            WebSocketClientDidFailParams _message = new WebSocketClientDidFailParams();
            _message.message = message;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(DID_FAIL_ORDINAL)));
        }

        @Override
        public void didClose(boolean wasClean, short code, String reason) {
            WebSocketClientDidCloseParams _message = new WebSocketClientDidCloseParams();
            _message.wasClean = wasClean;
            _message.code = code;
            _message.reason = reason;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(DID_CLOSE_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<WebSocketClient> {

        Stub(org.chromium.mojo.system.Core core, WebSocketClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WebSocketClient_Internal.MANAGER, messageWithHeader);
                    case DID_CONNECT_ORDINAL: {
                        WebSocketClientDidConnectParams data =
                                WebSocketClientDidConnectParams.deserialize(messageWithHeader.getPayload());
                        getImpl().didConnect(data.selectedSubprotocol, data.extensions, data.receiveStream);
                        return true;
                    }
                    case DID_RECEIVE_DATA_ORDINAL: {
                        WebSocketClientDidReceiveDataParams data =
                                WebSocketClientDidReceiveDataParams.deserialize(messageWithHeader.getPayload());
                        getImpl().didReceiveData(data.fin, data.type, data.numBytes);
                        return true;
                    }
                    case DID_RECEIVE_FLOW_CONTROL_ORDINAL: {
                        WebSocketClientDidReceiveFlowControlParams data =
                                WebSocketClientDidReceiveFlowControlParams.deserialize(messageWithHeader.getPayload());
                        getImpl().didReceiveFlowControl(data.quota);
                        return true;
                    }
                    case DID_FAIL_ORDINAL: {
                        WebSocketClientDidFailParams data =
                                WebSocketClientDidFailParams.deserialize(messageWithHeader.getPayload());
                        getImpl().didFail(data.message);
                        return true;
                    }
                    case DID_CLOSE_ORDINAL: {
                        WebSocketClientDidCloseParams data =
                                WebSocketClientDidCloseParams.deserialize(messageWithHeader.getPayload());
                        getImpl().didClose(data.wasClean, data.code, data.reason);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WebSocketClient_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class WebSocketClientDidConnectParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String selectedSubprotocol;
        public String extensions;
        public org.chromium.mojo.system.DataPipe.ConsumerHandle receiveStream;
    
        private WebSocketClientDidConnectParams(int version) {
            super(STRUCT_SIZE, version);
            receiveStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
        }
    
        public WebSocketClientDidConnectParams() {
            this(0);
        }
    
        public static WebSocketClientDidConnectParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketClientDidConnectParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidConnectParams result = new WebSocketClientDidConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.selectedSubprotocol = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.extensions = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readConsumerHandle(24, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(selectedSubprotocol, 8, false);
            encoder0.encode(extensions, 16, false);
            encoder0.encode(receiveStream, 24, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketClientDidConnectParams other = (WebSocketClientDidConnectParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.selectedSubprotocol, other.selectedSubprotocol))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.extensions, other.extensions))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.receiveStream, other.receiveStream))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(selectedSubprotocol);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(extensions);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(receiveStream);
            return result;
        }
    }

    static final class WebSocketClientDidReceiveDataParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean fin;
        public int type;
        public int numBytes;
    
        private WebSocketClientDidReceiveDataParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public WebSocketClientDidReceiveDataParams() {
            this(0);
        }
    
        public static WebSocketClientDidReceiveDataParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketClientDidReceiveDataParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidReceiveDataParams result = new WebSocketClientDidReceiveDataParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.fin = decoder0.readBoolean(8, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.type = decoder0.readInt(12);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.numBytes = decoder0.readInt(16);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(fin, 8, 0);
            encoder0.encode(type, 12);
            encoder0.encode(numBytes, 16);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketClientDidReceiveDataParams other = (WebSocketClientDidReceiveDataParams) object;
            if (this.fin != other.fin)
                return false;
            if (this.type != other.type)
                return false;
            if (this.numBytes != other.numBytes)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(fin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(type);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(numBytes);
            return result;
        }
    }

    static final class WebSocketClientDidReceiveFlowControlParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public long quota;
    
        private WebSocketClientDidReceiveFlowControlParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public WebSocketClientDidReceiveFlowControlParams() {
            this(0);
        }
    
        public static WebSocketClientDidReceiveFlowControlParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketClientDidReceiveFlowControlParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidReceiveFlowControlParams result = new WebSocketClientDidReceiveFlowControlParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.quota = decoder0.readLong(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(quota, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketClientDidReceiveFlowControlParams other = (WebSocketClientDidReceiveFlowControlParams) object;
            if (this.quota != other.quota)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(quota);
            return result;
        }
    }

    static final class WebSocketClientDidFailParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String message;
    
        private WebSocketClientDidFailParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public WebSocketClientDidFailParams() {
            this(0);
        }
    
        public static WebSocketClientDidFailParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketClientDidFailParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidFailParams result = new WebSocketClientDidFailParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.message = decoder0.readString(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(message, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketClientDidFailParams other = (WebSocketClientDidFailParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.message, other.message))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(message);
            return result;
        }
    }

    static final class WebSocketClientDidCloseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean wasClean;
        public short code;
        public String reason;
    
        private WebSocketClientDidCloseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public WebSocketClientDidCloseParams() {
            this(0);
        }
    
        public static WebSocketClientDidCloseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketClientDidCloseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketClientDidCloseParams result = new WebSocketClientDidCloseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.wasClean = decoder0.readBoolean(8, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.code = decoder0.readShort(10);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.reason = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(wasClean, 8, 0);
            encoder0.encode(code, 10);
            encoder0.encode(reason, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketClientDidCloseParams other = (WebSocketClientDidCloseParams) object;
            if (this.wasClean != other.wasClean)
                return false;
            if (this.code != other.code)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.reason, other.reason))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(wasClean);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(code);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(reason);
            return result;
        }
    }

}

